//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls         1.0
import wesual.data.Core        1.0
import wesual.data.FoodService 1.0

SuggestionBox {
    id : tagPicker

    property FoodServiceProduct product
    property DocumentListFilter tags
    property int biggestDelegateWidth : 0

    StringFilter {
        id : inputFilter
        property : "name"
        Component.onCompleted: {
            tags.filters = [inputFilter];
        }
    }

    displayPropertyName : "name"
    width : biggestDelegateWidth > 0 ? biggestDelegateWidth : 150
    placeholderText :
        qsTrId("7e1925edd9f1bcae")

    model : tags.resultingDocuments.length > 0 ? tags.resultingDocuments : []

    filter : inputFilter
    popupHeight : Math.min((tags.resultingDocuments.length * 28) + 8, 250)

    popupWillScroll : true

    delegate : SuggestionBoxDelegate {
        height : 28
        Row {
            width : tagPicker.biggestDelegateWidth
            height : 26
            spacing : 3
            anchors {
                verticalCenter : parent.verticalCenter
                left : parent.left
                leftMargin : 4
            }

            property int preferredWidth :
                                        tagImg.width + label.implicitWidth + 20

            onPreferredWidthChanged : {
                tagPicker.biggestDelegateWidth =
                Math.max(preferredWidth, tagPicker.biggestDelegateWidth, 150);
            }
            TagIcon {
                id : tagImg
                width : 25
                height : 25
                tag : document
                tintColor : "black"
                anchors.verticalCenter : parent.verticalCenter
            }
            Text {
                id : label
                text : document ?
                       document[view.displayPropertyName] : ""
                anchors.verticalCenter : parent.verticalCenter
                font {
                    family : UI.fontFamily(UI.PrimaryFont)
                    weight : UI.fontWeight(UI.SecondaryFont)
                    pixelSize : 14
                }
            }
        }
    }
    onDocumentChosen : {
        if (tagPicker.product && chosenDocument) {
            tagPicker.product.addTag(chosenDocument);
            tagPicker.focus = false;
        }
    }
}
